<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/*
 * Created on 01. Aug. 2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 */

/**
 * TableColumnProperties class file.
 *
 * PHP Version 5
 *  
 * LICENSE:
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * $Id: TableColumnProperties.php 264 2007-08-06 08:29:08Z nmarkgraf $
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  styles_properties
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     SVN: $Id: TableColumnProperties.php 264 2007-08-06 08:29:08Z nmarkgraf $
 * @link        http://opendocumentphp.org
 * @link        http://www.oasis-open.org/committees/download.php/20493/UCR.pdf OpenDocument Metadata Use Cases and Requirements
 * @since       0.5.3 - 01. Aug. 2007
 */

/**
 * 
 */
require_once 'OpenDocumentPHP/util/ODPElement.php';

/**
 * TableColumnProperties class.
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  styles_properties
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     Release: @package_version@
 * @link        http://opendocumentphp.org
 * @since       0.5.3 - 01. Aug. 2007
 * 
 */
class TableColumnProperties extends ODPElement 
{
    /**
     * Constructor method.
     * 
     * @since       0.5.3 - 01. Aug. 2007
     */
    function __construct($elem=null) 
    {         
        if (is_null($elem)) {
           parent::__construct('style:table-column-properties', '', self::STYLE);
        } else {
           parent::__construct($elem);         
        }   
    }

    /**
     * Set column width
     *
     * @access  public 
     * @param   float|string   $width  column width
     * @since   0.5.3 - 02. Aug. 2007
     */
    public function setColumnWidth($width)
    {
        if (is_float($width)) {
            $this->putStyleAttribute('column-width', "$width".'cm');    
        } else {
            $this->putStyleAttribute('column-width', $width);
        }    
    }

    /**
     * Set relative column width
     * 
     * @access  public
     * @param   float|string   $width  rel column width
     * @since   0.5.3 - 02. Aug. 2007
     */
    function setRelColumnWidth($width)
    {
        if (is_float($width)) {
            $this->putStyleAttribute('rel-column-width', "$width".'cm');    
        } else {
            $this->putStyleAttribute('rel-column-width', $width);
        }
        
    }

    /**
     * Set flag, so optimal column width is used (calculated by application).
     * 
     * @access  public
     * @since   0.5.3 - 02. Aug. 2007
     */
    function setUseOptimalColumnWidth()
    {
        $this->putStyleAttribute('use-optimal-column-width', 'true');
    }
}
?>
